;========================================================================================
;  adotr.s
;  Copyright (C) 2003-2023 Makoto Kamada
;
;  This file is part of the XEiJ (X68000 Emulator in Java).
;  You can use, modify and redistribute the XEiJ if the conditions are met.
;  Read the XEiJ License for more details.
;  https://stdkmd.net/xeij/
;========================================================================================

	.include	doscall.mac
	.include	control2.mac
	.include	iocscall.mac
	.include	misc.mac
	.include	push2.mac


  .if STEP=1

dBLK	reg	d4	;ubN̖(4̔{)
aOUT1	reg	a1	;o̓|C^1()
aOUT2	reg	a2	;o̓|C^2()
aIN	reg	a3	;̓|C^(4̔{)
aEND	reg	a4	;Ŝ̖(4̔{)

;<a1.l:Ŝ̖+B0͕s
step1:
	clr.l	d2
	lea.l	step1_data(pc,d2.w),aIN	;̓|C^(4̔{)
	add.l	a1,d2
	and.w	#-4,d2			;[؂̂Ă
	movea.l	d2,aEND			;Ŝ̖(4̔{)
	movea.l	aIN,aOUT1		;o̓|C^1()
	do
	;ubN̖߂
		moveq.l	#4*16,dBLK
		add.l	aIN,dBLK		;擪+4*16=Œ̖
		clr.l	d0
		add.l	aEND,d0			;Ŝ̖
		sub.l	dBLK,d0			;-Œ̖
		subx.l	d1,d1			;Ŝ̖<Œ̖?-1:0
		and.l	d1,d0			;Ŝ̖<Œ̖?Ŝ̖-Œ̖:0
		add.l	d0,dBLK			;(Ŝ̖<Œ̖?Ŝ̖:Œ̖)=ubN̖
	;31rbgϊ
	;	4224i31rbgB224**4=$96100000
		movea.l	aOUT1,aOUT2		;o̓|C^2()
		do
			move.l	#-$20202020,d1
			add.l	(aIN)+,d1		;4224i
			clr.l	d0			;31rbg
			moveq.l	#40,d3
			do
				movea.l	d0,a0			;1{
				lsl.l	#3,d0			;8{
				sub.l	a0,d0			;7{
				lsl.l	#5,d0			;224{
				rol.l	#8,d1			;4224ȉʂ
				add.l	d1,d0			;1oĉ
				sf.b	d1			;ŜĂ
				sub.l	d1,d0			;]Ȍ߂
				lsr.w	#1,d3			;20,10,5,2]1
			while	cc
			move.l	d0,(aOUT1)+		;31rbg
		while	<cmpa.l dBLK,aIN>,lo
	;1rbg
	;	0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
	;	0xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
	;	0xxxxxxxxxxxxxxxPQR0000000000000
	;		
	;	Pxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
	;	Qxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx
	;	Rxxxxxxxxxxxxxxx
		move.w	-(aOUT1),d1		;Ō2oCg
		do
			clr.l	d0
			add.w	d1,d1			;1rbgo
			roxr.l	#1,d0
			add.l	d0,(aOUT2)+		;1rbgɉ
		while	<cmpa.l aOUT1,aOUT2>,lo
	while	<cmpa.l aEND,aIN>,lo
;LbVtbV
	lea.l	1f+(2f-1f)*2-32(pc),a0
	moveq.l	#-(2f-1f),d2
	.cpu	68020
	jmp	32(a0,d2.w*2)
	.cpu	68000
1:	clr.w	d1
	addq.w	#3,d1
	IOCS	_SYS_STAT
2:
;s
;<a1.l:(4̔{+2)
	.align	4,$2048			;movea.l a0,a0

;f[^
;	data:	GR[hꂽf[^.l[]
;		($1A)
;	a1:
step1_data:

  .endif	;STEP=1


  .if STEP=2

dOUTEND	reg	d3	;.l o̓obt@̖
dDICBIT	reg	d4	;.b ̃y[W̃rbgB1`15
dDICEND	reg	d5	;.l ̖()
dTEMP	reg	d6	;.b rbgǂݏöꎞۊǏꏊBdLEFTrbgcĂ
dLEFT	reg	d7	;.b dTEMP̎crbg
aOUTBUF	reg	a1	;.l o̓obt@̐擪()
aINPPTR	reg	a2	;.l ̓|C^
aINPEND	reg	a3	;.l ̓obt@̖()
aOUTPTR	reg	a4	;.l o̓|C^
aDICBUF	reg	a5	;.l ̐擪()BAhX.l,.l
aDICPTR	reg	a6	;.l |C^

;<a1.l:̓obt@̖B擪̏o̓obt@̒܂߂Ē4ȉ͕s
step2:
;o̓obt@̐擪
	moveq.l	#1,d0			;̓obt@̖ɐ؂グ
	add.l	a1,d0
	and.w	#-2,d0
	movea.l	d0,aOUTBUF		;o̓obt@̐擪()
;rbgǂݏȍ
	moveq.l	#0,dTEMP		;rbgǂݏöꎞۊǏꏊ
	moveq.l	#0,dLEFT		;dTEMP̎crbg
	lea.l	step2_data(pc),aINPPTR	;̓obt@̐擪̓|C^
;o̓obt@̖
	moveq.l	#24,d1
	bsr	get_bits
	move.l	d0,dOUTEND		;o̓obt@̒
	add.l	aOUTBUF,dOUTEND		;+o̓obt@̐擪=o̓obt@̖
;̐擪
	moveq.l	#1,d0			;o̓obt@̖ɐ؂グ
	add.l	dOUTEND,d0
	and.w	#-2,d0
	movea.l	d0,aDICBUF		;̐擪()
;̃y[W̃rbg
	moveq.l	#4,d1
	bsr	get_bits
	goto	eq,data_error		;0͕s
	move.b	d0,dDICBIT		;̃y[W̃rbg
;̖()
	moveq.l	#8,dDICEND
	lsl.l	dDICBIT,dDICEND		;8*̃y[W=̒
	add.l	aDICBUF,dDICEND		;+̐擪=̖()
;mۂ
	DOS	_GETPDB
	move.l	dDICEND,d1
	sub.l	d0,d1
	move.l	d1,-(sp)		;ubN̒
	move.l	d0,-(sp)		;ubN̐擪
	DOS	_SETBLOCK
	addq.l	#8,sp
	goto	<tst.l d0>,mi,out_of_memory
;
;	`GgQƂƂG[ɂ邽
	moveq.l	#0,d0
	movea.l	aDICBUF,a0
	do
		move.l	d0,(a0)+
		move.l	d0,(a0)+
	while	<cmpa.l dDICEND,a0>,lo
;ϐ
	movea.l	aOUTBUF,aOUTPTR		;o̓obt@̐擪o̓|C^
	movea.l	aDICBUF,aDICPTR		;̐擪|C^()
;𓀃[v
	do
	;̓obt@̖𓥂݉zĂȂ
		goto	<cmpa.l aOUTBUF,aINPPTR>,hs,data_error
	;ɂ邩
		moveq.l	#1,d1
		bsr	get_bits
		if	eq			;0=ɂȂ
		;ɓo^
			move.l	aOUTPTR,(aDICPTR)+	;VP̐擪
			moveq.l	#1,d0
			move.l	d0,(aDICPTR)+		;VP̒
		else				;1=ɂ
		;̃y[Wԍǂݏo
			move.b	dDICBIT,d1
			bsr	get_bits
		;o
			lsl.l	#3,d0			;8*̃y[Wԍ
			move.l	(aDICBUF,d0.l),a0	;a0.l:ɂP̐擪
			move.l	4(aDICBUF,d0.l),d0	;d0.l:ɂP̒
		;Gg`Ă邩
			goto	eq,data_error
		;o̓obt@̖𓥂݉zȂ
		;	Ŏ~߂ȂƃubN̖𓥂݉z\
			addq.l	#1,d0			;ɂP̒+1
			move.l	d0,d1
			add.l	aOUTPTR,d1
			goto	<cmp.l dOUTEND,d1>,hi,data_error
		;ɓo^
			move.l	aOUTPTR,(aDICPTR)+	;VP̐擪
			move.l	d0,(aDICPTR)+		;ɂP̒+1VP̒
		;ɂPo͂
			subq.l	#2,d0			;ɂP̒-1
			forlong	d0
				move.b	(a0)+,(aOUTPTR)+
			next
		endif
	;o͂
		move.b	(aINPPTR)+,(aOUTPTR)+
	;|C^߂
		if	<cmpa.l dDICEND,aDICPTR>,eq
			movea.l aDICBUF,aDICPTR
		endif
	while	<cmpa.l dOUTEND,aOUTPTR>,lo
;LbVtbV
	moveq.l	#-(2f-1f),d0
	.cpu	68020
	jmp	1f+(2f-1f)*2(pc,d0.w*2)
	.cpu	68000
1:	moveq.l	#3,d1
	IOCS	_SYS_STAT
2:
;s
	movea.l	aOUTBUF,a0		;o̓obt@̐擪
	jmp	(a0)

print_exit:
	DOS	_PRINT
	DOS	_EXIT

out_of_memory:
	pea.l	@f(pc)
	goto	print_exit
@@:	.dc.b	'out of memory',13,10,0
	.even

data_error:
	pea.l	@f(pc)
	goto	print_exit
@@:	.dc.b	'data error',13,10,0
	.even

;<d1.b:ǂݏorbg
;>d0.l:ǂݏof[^
;>z:eq=0,ne=0ȊO
;?d1-d2
get_bits:
	moveq.l	#0,d0			;ǂݏof[^B24rbgg
	do
		if	<tst.b dLEFT>,eq	;dTEMP
			move.b	(aINPPTR)+,dTEMP	;VdTEMP
			addq.b	#8,dLEFT		;dTEMP̎crbg
		endif
		move.b	d1,d2
		if	<cmp.b dLEFT,d2>,hi
			move.b	dLEFT,d2	;d2.b:min(ǂݏorbg,dTEMP̎crbg)
		endif
		move.b	dTEMP,d0		;ǂݏof[^
		lsl.l	d2,d0			;ʂɉ
		lsl.b	d2,dTEMP		;dTEMP̏ʂ牟o
		sub.b	d2,dLEFT		;dTEMP̎crbg
		sub.b	d2,d1			;ǂݏorbg̎c
	while	ne
	lsr.l	#8,d0			;ǂݏof[^
	rts

;f[^
;	̓obt@Ao̓obt@A
step2_data:

  .endif	;STEP=2


  .if STEP=3

dLENGTH	reg	d3	;.l {̂̒
aNAME	reg	a2	;.l t@C
aBODY	reg	a3	;.l {
aTABLE	reg	a4	;.l CRC32e[u
aEND	reg	a5	;.l CRC32e[u̖

	.offset	0
NAME:	.ds.b	24
DATE:	.ds.l	1
CRC32:	.ds.l	1
LENGTH:	.ds.l	1
BODY:
	.text

;obt@\
	lea.l	step3_data(pc),aNAME	;t@C
	move.l	LENGTH-NAME(aNAME),dLENGTH	;{̂̒
	lea.l	BODY-NAME(aNAME),aBODY	;{
	move.l	aBODY,d0		;{
	add.l	dLENGTH,d0		;+{̂̒={̖̂
	addq.l	#1,d0
	and.w	#-2,d0			;ɌJグ
	movea.l	d0,aTABLE		;CRC32e[u
	lea.l	4*256(aTABLE),aEND	;CRC32e[u̖
;mۂ
	DOS	_GETPDB
	move.l	aEND,d1
	sub.l	d0,d1
	move.l	d1,-(sp)		;ubN̒
	move.l	d0,-(sp)		;ubN̐擪
	DOS	_SETBLOCK
	addq.l	#8,sp
	goto	<tst.l d0>,mi,out_of_memory
;CRC32e[u
	movea.l	aTABLE,a0
	moveq.l	#0,d1
	do
		move.l	d1,d0
		moveq.l	#8-1,d2
		for	d2
			lsr.l	#1,d0
			if	cs
				eori.l	#$EDB88320,d0
			endif
		next
		move.l	d0,(a0)+
		addq.b	#1,d1
	while	cc
;CRC32vZ
	movea.l	aTABLE,a1
	moveq.l	#0,d0			;CRC32
	move.l	dLENGTH,d1		;{̂̒
	movea.l	aBODY,a0		;{
	not.l	d0
	forcontinuelong	d1
		moveq.l	#0,d2
		move.b	(a0)+,d2
		eor.b	d0,d2
		lsr.l	#8,d0
		lsl.w	#2,d2
		move.l	(a1,d2.l),d2
		eor.l	d2,d0
	next
	not.l	d0
;CRC32r
	goto	<cmp.l CRC32-NAME(aNAME),d0>,ne,crc_error
;t@C
	move.w	#$0020,-(sp)
	move.l	aNAME,-(sp)
	DOS	_CREATE
	addq.l	#6,sp
	goto	<tst.l d0>,mi,cannot_write
	move.l	dLENGTH,-(sp)
	move.l	aBODY,-(sp)
	move.w	d0,-(sp)
	DOS	_WRITE
	move.l	d0,d1
	move.l	DATE-NAME(aNAME),2(sp)
	DOS	_FILEDATE
	DOS	_CLOSE
	lea.l	10(sp),sp
	if	<cmp.l dLENGTH,d1>,ne
		move.l	aNAME,-(sp)
		DOS	_DELETE
		addq.l	#4,sp
		goto	cannot_write
	endif
;I
	move.l	aNAME,-(sp)
	DOS	_PRINT
	pea.l	@f(pc)
print_exit:
	DOS	_PRINT
	DOS	_EXIT
@@:	.dc.b	' created',13,10,0
	.even

out_of_memory:
	pea.l	@f(pc)
	goto	print_exit
@@:	.dc.b	'out of memory',13,10,0
	.even

crc_error:
	pea.l	@f(pc)
	goto	print_exit
@@:	.dc.b	'crc error',13,10,0
	.even

cannot_write:
	pea.l	@f(pc)
	goto	print_exit
@@:	.dc.b	'cannot write',13,10,0
	.even

;f[^
;	data:	t@C.b[24]
;		.l
;		{̂CRC32.l
;		{̂̒.l
;		{.b[{̂̒]
;		.even
;	a1:	CRC32e[u
step3_data:

  .endif	;STEP=3


